require( "scripts/chocshopstyle.lua" );

-- Initializes the current player name, and whether to delete the initial text
local playername = gEnterNameValue;

dialogW = 420;
dialogH = 270;
local en_closed = false;

MakeDialog
{
	name = "entername",
	
	VTintWindow
	{
	    x		= 0, 
	    y		= 0, 
	    w		= 800, 
	    h		= 600,
	    color	= Color( 0, 0, 0, 200 ),
	    time	= 200,
	    fade	= true
	},
	
	RBounceWindow
	{
		x			= 400 - dialogW/2,
		y			= -600 - dialogH - 10,
		w           = dialogW,
		h           = dialogH,
	    targetposx	= 400 - dialogW/2, 
	    targetposy	= 300 - dialogH/2,
	    bouncelen	= 200, 
	    bouncefunc	= "sincx",
		
		KSplit9Image{
		    x = 0, 
		    y = 0,
		    w = dialogW, 
		    h = dialogH,
		    image = "ui/backgrounds/split9_dialog",
		    x1 = 60,
		    x2 = 60,
		    y1 = 60,
		    y2 = 60,
		},
		---------------------------------------------- Title
		Text
		{
			x		= 0,
			y		= 42,
			w		= kMax,
			h		= 30,
			font	= ChoosePlayer_HeaderFont,
			name	= "entername_title_text",
			flags	= kHAlignCenter + kVAlignTop,
			label	= "#<outline color='000000' size='1'>"..GetString( "entername_title" ).."</outline>"
		},
		
		Bitmap{
		    x       = dialogW/2 - 80,
		    y       = kMax - 100,
		    image   = "ui/story/btn_trim_left",
		},
		Bitmap{
		    x       = dialogW/2 + 1,
		    y       = kMax - 100,
		    image   = "ui/story/btn_trim_left",
		    hflip   = true,
		},
		
		SetStyle(CSOvalGreenButtonStyle);
		---------------------------------------------- Ok
		RDisableButton
		{
			x			= dialogW/2 - 113 - 33,
			y			= kMax - 74 - 30,
			name		= "ok",
			type		= kPush,
			default		= true,
			SelectLayer( 0 ),
		    Text
		    {
			    x		= 0,
			    y		= 0,
			    w		= kMax,
			    h		= kMax,
			    label	= "app_ok",
			    flags	= kHAlignCenter + kVAlignCenter,			
			    font	= ChoosePlayer_ButtonFont
		    },
            
			SelectLayer( 1 ),
		    Text
		    {
			    x		= 0,
			    y		= 0,
			    w		= kMax,
			    h		= kMax,
			    label	= "app_ok",
			    flags	= kHAlignCenter + kVAlignCenter,			
			    font	= ChoosePlayer_ButtonFont
		    },
  
			SelectLayer( 2 ),
		    Text
		    {
			    x		= 0,
			    y		= 0,
			    w		= kMax,
			    h		= kMax,
			    label	= "app_ok",
			    flags	= kHAlignCenter + kVAlignCenter,			
			    font	= ChoosePlayer_ButtonFont
		    },
		    
			SelectLayer( 3 ),
			RWindow
			{
				x		= 0,
				y		= 0,
				image	= "ui/buttons/oval_green_up",
				imagealpha	= 0.1,
				
				Text
				{
					x		= 0,
					y		= 0,
					w		= kMax,
					h		= kMax,
					label	= "app_ok",
					flags	= kHAlignCenter + kVAlignCenter,			
					font	= ChoosePlayer_DisabledButtonFont
				},
			},
			
			command		= 
				function()
				    --if( not en_closed ) then
					    if( IsNameInUse( GetLabel( "entername_name_textedit" ) ) ) then
						    DisplayDialog { "scripts/ok.lua", body = "entername_nameinuse", title = "" };
						    SetFocus( "entername_name_textedit" )
					    else
				            --en_closed = true;
						    PostMessage( CreateNamedMessage( kTintOff ) );
						    DoTransition( kBounceBack );
						    CloseWindow( GetLabel( 'entername_name_textedit' ) );
					    end
					--end
				end
		},
		SetStyle(CSOvalRedButtonStyle);
		---------------------------------------------- Cancel
		Button
		{
			x			= dialogW/2 + 33,
			y			= kMax - 74 - 30,	
			name		= "entername_cancel_button",
			label		= "app_cancel",
			type		= kPush,
			command		= 
				function()
				   -- if( not en_closed ) then
				        --en_closed = true;
					    PostMessage( CreateNamedMessage( kTintOff ) );
					    DoTransition( kBounceBack );
						CloseWindow();
					--end
				end
		},
		---------------------------------------------- Enter Name
		KSplit9Image
		{
			x		= kCenter,
			y		= kCenter,
			image	= "gfx/textfield",
			w       = 360,
			h       = 32,
			x1 = 5,
			x2 = 5,
			y1 = 5,
			y2 = 5,			
			
			RTextEditDisable
			{
				x		= 3,
				y		= 5,
				w		= kMax-3,
				h		= kMax,
				font	= Entername_NameFont,
				name	= "entername_name_textedit",
				label	= playername,
				length	= 20,						-- The maximum length
				ignore	= kIllegalNameChars,		-- What letters to ignore
				disable = "ok"						-- What button to disable
			},
		},
	},
}

SetFocus( "entername_name_textedit" );